/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.circulinear.GenericCirculinearRing2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.Polygon2DUtils;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearRing2D
extends Polyline2D
implements CirculinearRing2D {
    public static LinearRing2D create(Collection<? extends Point2D> points) {
        return new LinearRing2D(points);
    }

    public static LinearRing2D create(Point2D ... vertices) {
        return new LinearRing2D(vertices);
    }

    public LinearRing2D() {
    }

    public LinearRing2D(Point2D initialPoint) {
        super(initialPoint);
    }

    public LinearRing2D(Point2D ... vertices) {
        super(vertices);
    }

    public LinearRing2D(double[] xcoords, double[] ycoords) {
        super(xcoords, ycoords);
    }

    public LinearRing2D(Collection<? extends Point2D> points) {
        super(points);
    }

    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    public double getSignedArea() {
        double area = 0.0;
        Point2D prev = (Point2D)this.vertices.get(this.vertices.size() - 1);
        int i = 0;
        while (i < this.vertices.size()) {
            Point2D point = (Point2D)this.vertices.get(i);
            area += prev.getX() * point.getY() - prev.getY() * point.getX();
            prev = point;
            ++i;
        }
        return area /= 2.0;
    }

    @Override
    public Collection<LineSegment2D> getEdges() {
        int n = this.vertices.size();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(n);
        if (n < 2) {
            return edges;
        }
        int i = 0;
        while (i < n - 1) {
            edges.add(new LineSegment2D((Point2D)this.vertices.get(i), (Point2D)this.vertices.get(i + 1)));
            ++i;
        }
        Point2D p0 = (Point2D)this.vertices.get(0);
        Point2D pn = (Point2D)this.vertices.get(n - 1);
        if (pn.getDistance(p0) > 1.0E-12) {
            edges.add(new LineSegment2D(pn, p0));
        }
        return edges;
    }

    @Override
    public LineSegment2D getLastEdge() {
        int n = this.vertices.size();
        if (n < 2) {
            return null;
        }
        return new LineSegment2D((Point2D)this.vertices.get(n - 1), (Point2D)this.vertices.get(0));
    }

    @Override
    public CirculinearRing2D getParallel(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return GenericCirculinearRing2D.create(bc.createContinuousParallel(this, dist).getSmoothPieces());
    }

    @Override
    public CirculinearRing2D transform(CircleInversion2D inv) {
        Collection<LineSegment2D> edges = this.getEdges();
        ArrayList<CirculinearElement2D> arcs = new ArrayList<CirculinearElement2D>(edges.size());
        for (LineSegment2D edge : edges) {
            arcs.add(edge.transform(inv));
        }
        return new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)arcs);
    }

    public Collection<Contour2D> getBoundaryCurves() {
        ArrayList<Contour2D> list = new ArrayList<Contour2D>(1);
        list.add(this);
        return list;
    }

    @Override
    public Domain2D getDomain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        double dist = this.getDistance(x, y);
        return this.isInside(x, y) ? -dist : dist;
    }

    @Override
    public double getSignedDistance(Point2D point) {
        return this.getSignedDistance(point.getX(), point.getY());
    }

    @Override
    public double getWindingAngle(Point2D point) {
        int wn = Polygon2DUtils.windingNumber(this.vertices, point);
        return (double)(wn * 2) * Math.PI;
    }

    public boolean isInside(double x, double y) {
        return this.isInside(new Point2D(x, y));
    }

    @Override
    public boolean isInside(Point2D point) {
        if (this.contains(point)) {
            return true;
        }
        double area = this.getSignedArea();
        int winding = Polygon2DUtils.windingNumber(this.vertices, point);
        if (area > 0.0) {
            return winding == 1;
        }
        return winding == 0;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public Point2D getPoint(double t) {
        double t0 = this.getT0();
        double t1 = this.getT1();
        t = Math.max(Math.min(t, t1), t0);
        int n = this.vertices.size();
        int ind0 = (int)Math.floor(t + 1.0E-12);
        double tl = t - (double)ind0;
        if (ind0 == n) {
            ind0 = 0;
        }
        Point2D p0 = (Point2D)this.vertices.get(ind0);
        if (Math.abs(t - (double)ind0) < 1.0E-12) {
            return new Point2D(p0);
        }
        int ind1 = ind0 + 1;
        if (ind1 == n) {
            ind1 = 0;
        }
        Point2D p1 = (Point2D)this.vertices.get(ind1);
        double x0 = p0.getX();
        double y0 = p0.getY();
        double dx = p1.getX() - x0;
        double dy = p1.getY() - y0;
        return new Point2D(x0 + tl * dx, y0 + tl * dy);
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return this.vertices.size();
    }

    @Override
    public Point2D getFirstPoint() {
        if (this.vertices.size() == 0) {
            return null;
        }
        return (Point2D)this.vertices.get(0);
    }

    @Override
    public Point2D getLastPoint() {
        if (this.vertices.size() == 0) {
            return null;
        }
        return (Point2D)this.vertices.get(0);
    }

    public Collection<? extends LinearRing2D> getContinuousCurves() {
        return LinearRing2D.wrapCurve(this);
    }

    @Override
    public LinearRing2D getReverseCurve() {
        Point2D[] points2 = new Point2D[this.vertices.size()];
        int n = this.vertices.size();
        if (n > 0) {
            points2[0] = (Point2D)this.vertices.get(0);
            int i = 1;
            while (i < n) {
                points2[i] = (Point2D)this.vertices.get(n - i);
                ++i;
            }
        }
        return new LinearRing2D(points2);
    }

    @Override
    public Polyline2D getSubCurve(double t0, double t1) {
        int ind1;
        Polyline2D res = new Polyline2D();
        int indMax = this.getVertexNumber();
        t0 = Math.min(Math.max(t0, 0.0), (double)indMax);
        t1 = Math.min(Math.max(t1, 0.0), (double)indMax);
        int ind0 = (int)Math.floor(t0 + 1.0E-12);
        if (ind0 == (ind1 = (int)Math.floor(t1 + 1.0E-12)) && t0 < t1) {
            res.addVertex(this.getPoint(t0));
            res.addVertex(this.getPoint(t1));
            return res;
        }
        res.addVertex(this.getPoint(t0));
        if (ind1 > ind0) {
            int n = ind0 + 1;
            while (n <= ind1) {
                res.addVertex((Point2D)this.vertices.get(n));
                ++n;
            }
        } else {
            int n = ind0 + 1;
            while (n < indMax) {
                res.addVertex((Point2D)this.vertices.get(n));
                ++n;
            }
            n = 0;
            while (n <= ind1) {
                res.addVertex((Point2D)this.vertices.get(n));
                ++n;
            }
        }
        res.addVertex(this.getPoint(t1));
        return res;
    }

    @Override
    public LinearRing2D transform(AffineTransform2D trans) {
        Point2D[] pts = new Point2D[this.vertices.size()];
        int i = 0;
        while (i < this.vertices.size()) {
            pts[i] = trans.transform((Point2D)this.vertices.get(i));
            ++i;
        }
        return new LinearRing2D(pts);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (this.vertices.size() < 2) {
            return path;
        }
        Point2D p0 = this.getLastPoint();
        path.moveTo((float)p0.getX(), (float)p0.getY());
        for (Point2D point : this.vertices) {
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        path.closePath();
        return path;
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.vertices.size() < 2) {
            return path;
        }
        return this.appendPath(path);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LinearRing2D)) {
            return false;
        }
        LinearRing2D ring = (LinearRing2D)object;
        if (this.vertices.size() != ring.vertices.size()) {
            return false;
        }
        int i = 0;
        while (i < this.vertices.size()) {
            if (!((Point2D)this.vertices.get(i)).equals(ring.vertices.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public LinearRing2D clone() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices.size());
        for (Point2D point : this.vertices) {
            array.add(point.clone());
        }
        return new LinearRing2D(array);
    }

    public static /* bridge */ /* synthetic */ Polyline2D create(Point2D ... point2DArray) {
        return LinearRing2D.create(point2DArray);
    }
}

